﻿USE VoxcoSystem
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_StartAgentSession]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[sp_StartAgentSession]
GO

CREATE PROCEDURE [dbo].[sp_StartAgentSession]
	@dirSrvSessionGuid UniqueIdentifier,
	@serverId int,
	@userId int,
	@projectId int,
	@testMode bit,
	@ExtensionType nvarchar(10) = null,
	@AgentPhoneNumber nvarchar(255) = null,
	@TelephonyServerId int = null,
	@loginDateTime datetime = null
AS
BEGIN
	SET NOCOUNT ON 
	INSERT INTO AgentSession (dirSrvSessionGuid, serverId, userId, loginDateTime, projectId, testMode, ExtensionType, AgentPhoneNumber, TelephonyServerId)
	VALUES (@dirSrvSessionGuid, @serverId, @userId, ISNULL(@loginDateTime, GETUTCDATE()), @projectId, @testMode, @ExtensionType, @AgentPhoneNumber, @TelephonyServerId)
	SELECT SCOPE_IDENTITY()
END
GO
